function r = plotQRfunc(sit,A,howplot)
% sit: shift history

if nargin<3
    howplot='log';
end
ei = eig(A);
r = @(z)1./(prod(z-sit));
xx = linspace(-4,4,1000);
xx = [xx ei.']; xx = sort(xx);
rxx = zeros(1,length(xx));
rei = zeros(1,length(ei));
for ii = 1:length(xx)
    rxx(ii) = r(xx(ii));
end
for ii = 1:length(ei)
    rei(ii) = r(ei(ii));
end
chebfunsetting
if howplot=='log'
plot(xx,log10(abs(rxx)),'b',LW,lw),hold on
plot(ei,log10(abs(rei)),'r.',MS,ms*2),shg
else
plot(xx,abs(rxx),'b',LW,lw),hold on
plot(ei,abs(rei),'r.',MS,ms*2),shg    
end
set(gca,FS,fs)
set(gca,'ytick',5*[-5:5])
ylabel('log|p(\lambda)|',FS,fs)
grid on,hold off
end

