%% Practical 0 -- Model solutions
% Nick Hale, Asgeir Birkisson, Mohsin Javed, Behnam Hashemi

clear, clc, close all, format short

%% Problem 1
day = [5, 10, 20]'

% note date is inbuilt
date

%% Problem 2
% Compute minimum, maximum, average and standard deviation:
v = 1:100;
min(v)
max(v)
mean(v)
std(v)

%% Problem 3
% Construct a vector of prime numbers from 1 to 1000:
vec = primes(1000);
length(vec)

%%
% Compute sum of the elements:
sum(vec)

% Compute the average:
sum(vec)/length(vec)

% Compute the average again:
mean(vec)

%% Problem 4
% Multiply the 10th entry by 10:
vec(10) = 10*vec(10);

%%
% Delete entries 20-30:
vec(20:30) = [];

%%
% Compute the new average:
mean(vec)


%% Problem 5
% Compute the 2 norm of A, given by:
A = [1, 2, 3;
     4, 5, 6;
     7, 8, 9]
 
 %%
 % Use the norm function with two arguments:
 norm(A, 2)
 % note, second argument could be deleted, default is 2-norm
 
 %% Problem 6
 % Compute the 2 norm of a more complicated matrix, with entries from 1 to 1000:
vec = 1:1000;

% See >>> help reshape <<< for meaning of input parameters
A = reshape(vec, 100, 10)';

%%
% Now obtain the 2 norm:
norm(A, 2)

%% Problem 7
% We use the _factor_ command for computing the prime factors:
vec = factor(123456789);

%%
% Let's check whether this is really correct:
prod(vec)

% OK. Now, let's compute the sum:
sum(vec)

%% Problem 8
% Find the second entry of the solution of (A+I)*x = [1 2 3]', using A from

A = [1 2 3; 4 5 6; 7 8 9];
% Use >>> eye <<<, which gives an identity matrix
B = A + eye(3)
x = B\[1; 2; 3]

%% 
% Obtain the second entry:
x(2)

%% Problem 9
% Begin by constructing B:
B = A;
B(1, :) = fliplr(A(1,:))
x = (B + eye(3))\[1; 2; 3]
x(2)

%% Problem 10
% Construct 1000 equispaced points between 0 and 10
x = linspace(0, 10, 1000);

%% Problem 11
% 97 is the ASCII code for the first alphabet letter 'a' (Try >> char(97)). 
% So, to start from 'a', we add a random integer between 1 and 26 and add 
% it to 96:
v = char(96 + randi(26, [1, 26]))
abc = sort(unique(v))
size(abc)

%% Problem 12
% Plot various functions of x on the same plot. Notice .^2 for finding
% square of entries of a vector
plot(x, sin(x), x, sin(x.^2), x, sin(x) + sin(x.^2)) 

%%
% Another option would be to use hold on
plot(x, sin(x), 'b-');
hold on
plot(x, sin(x.^2), 'r--', 'linewidth', 2)
plot(x, sin(x)+sin(x.^2), '-.mo')
hold off

%%
% See >>> doc linespec <<< for more options.

%%
% Now add legends, title and grid
legend('sin(x)', 'sin(x^2)', 'sin(x)+sin(x^2)', 'location', 'sw')
xlabel('x', 'fontsize', 16)
grid on
% Bring the figure to the front using shg:
shg

%% Problem 13
% Plot a semi-log plot of exp(-x^2) on [0 5];
x = linspace(0, 5, 100);
semilogy(x, exp(-x.^2))

%% Problem 14
% Eigenvalues and eigenvectors of a random matrix:
A = rand(10, 10) % Create a random matrix
[V, D] = eig(A)  % Find eigenvectors and eigenvalues of A

%% 
% The eigenvalues of A lie along the diagonal of D, obtain them using diag:
evals = diag(D)

%%
% Plot them as dots blue dots in the complex plane on the first subplot:
subplot(1, 2, 1)
plot(evals, 'b.', 'markersize', 18)

%%
% The eigenvectors are the columns of the matrix V. 
% By calling plot on a matrix, each column is plotted individually as 
% follows:
subplot(1, 2, 2)  % Now we want to plot on the second subplot
plot(V)
shg
