%% Theory1:
% MSc MATLAB Crash Course: Scripts, Logic, Control Structures and Anonymous
% Functions.
%
% Originally written by Nick Hale, Oct 2013.
% Extended by Mohsin Javed, Oct 2014.
% Further extended by Mohsin Javed, Oct 2015.
% Modified by Behnam Hashemi and Hadrien Montanelli, Sep. 2016.

%%
% We have been using MATLAB as a big calculator. 
% Uptil now, we have written everything directly to the command window. When
% we're writing longer and perhaps more serioius codes, it's more 
% convenient to use 'scripts'. (We'll get to 'functions' later on.)

%% 1. SCRIPTS
% What is a script?
% A script is an m-file containing a collection of simple MATLAB commands, 
% which we can run automatically by executing it.

% My startup file:
% edit startup

% path 

% addpath: 
% adds the specified folder to the top of the search path for the current 
% MATLAB session.

% Example in MAC: 
% addpath('/Users/jari/Desktop/')

% pathtool
% which

%% 2. LOGIC

%% 
% MATLAB supports the boolean operators true and false:
true
false

%% 
% Although these look like 1 and 0, they're actually a little different:
class(true)
class(false)
class(1)
class(0)

%% ==
% a == b will return true if a is equal to b:
2 == 2
[2 3 4] == [2 3 4]

% and false otherwise:
0 == 1
3.14 == pi
[2 3 4] == [2 4 6]

% Note that we use == rather than = to distinguish from assigning values. 
% (For example, try typing 1 = 1)

%% ~=
% Conversely a ~= b will return true if a is _not_ equal to b:
1 ~= 1
0 ~= 1

%% ~ 
% The command ~ switches a true value to false, and vice-versa:
~true
~false
~(1 == 1)
~[true; false]

%% & and |
% Here a & b and c | d are shorthand for and(a, b) and or(c, d), respectively:
true & true
true & false
true | true
true | false

%% < and >
% These guys do the obvious thing:
5 < 8
exp(pi) > pi.^exp(1)
3 <= 3

%% FIND
% 
help find
A = rand(4, 4)
idx = find(A < 0.5);
A(idx) = 0

%% 
% Note that almost all the statements above can be applied to vectors / matrices 
% (this is how MATLAB likes to operate). 

%% ALL, ANY
% all(v) will return true if all the
% elements of the vector v are true, and false otherwise. Conversely, 
% any(v) will return true if any of the elements are true.
v = [true, false, true];
all(v)
any(v)

%% 3. CONTROL STRUCTURES
% MATLAB uses the same control structures as most other languages:
%  * if
%  * while
%  * for
%
% Let's look at them in more detail.

%% IF
% Control structures in MATLAB are started by a conditional statement and 
% ended by the command end. For example
flag = 0;
if ( flag )
    disp( 'true' )
end

flag = 1;
if ( flag )
    disp( 'true' )
end

%% ELSE
flag = 0;
if ( flag )             % (Parenthesis aren't required, but look nice!)
    disp('true')
else
    disp('false')
end

%% ELSEIF
% Extra choices can be made with ELSEIF:
a = -1;
if ( a > 0 )
    disp('a is positive');
elseif ( a < 0 )
    disp('a is negative');
else
    disp('a is zero!');
end

%% WHILE
% A WHILE loop is like an IF statement that keeps going. 
% In particular, it will
% continue to execute the contained code block until the conditional 
% argument is changed to false. For example:
k = 0;
while ( k < 10 )
    k = k + 1
end

%% FOR
% FOR loops are not conditional, but execute the code block for each of the
% arguments. A FOR loop will look like:
k = rand(10, 1);
for i = 1:length(k)
    [i,k(i)]
end

for i = 1:2:length(k)
    [i,k(i)]
end

%% CONTINUE and BREAK
% These guys can be used to manipulate the execution flow in FOR and WHILE
% loops. CONTINUE will cause the current evaluation point to return to the 
% WHILE or FOR command, whereas BREAK will immediately cease the loop. For 
% example:
disp('k = ')
for k = [1, 2, 3, 4]
    if ( k == 3 )
        continue
    end
    disp(k)
end

%%
disp('k = ')
for k = [1, 2, 3, 4]
    if ( k == 3 )for i = 1:2:length(k)
    [i,k(i)]
end

        break
    end
    disp(k)
end

%% 
A = zeros(10)
for i = 1:10
    for j = 1:10
        if ( j == 5 )
            break
        end
        A(i,j) = rand;
    end
end
A

%% 4. ANONYMOUS FUNCTIONS
% Simple functions that require only one line can be invoked using 
% 'anonymous functions'.
% For example:
f = @(x) cos(pi*x) + exp(cos(x));

%%
% We can then evaluate this function f at x = 0 by the following:
f0 = f(0)

%%
% We can also do this:
x = -1 : 0.01 : 1;
plot(x, f(x))

%%
% Or even at a vector / matrix of points
fr = f(rand(2, 3))

%%
% Anonymous functions also support two or more variables:
g = @(x, y) sin(x) + y*cos(x)

xx = linspace(-pi, pi);
plot(xx, g(xx, 0.1)); hold on
plot(xx, g(xx, 2.1), 'r'); hold off

%% 
% If your functions is complicated it is better to write it as an m-file
% (we'll see this next time), but if it is very short and only has a single
% output, the anonymous functions can be very useful.

%% 5. SOME FLOATING POINT ISSUES
(1 + eps/2) - 1
(1 + eps) - 1
(1 + eps/2 + eps/2) - 1
(2 + eps) - 2
(2 + 2*eps) - 2
