function varargout = quadform3(varargin)
%QUADFORMF3   Compute the roots of a quadratic.
%   X = QUADFORMF3(A, B, C) returns the roots of A*X^2 + B*X + C = 0 in a single
%   vector X.
% 
%   [X1, X2] = QUADFORMF3(A, B, C) returns the roots separately in X1 and X2.
if ( nargin < 3 )
    error('Not enough input arguments.')
end

% Get the coefficients (cell-array):
a = varargin{1};
b = varargin{2};
c = varargin{3};

% Compute disctiminant with DISC function:
d = disc(a, b, c);

% First root:
x(1) = (-b - d)/(2*a);

% Second root:
x(2) = (-b + d)/(2*a);

if ( nargout < 2 )
    
    varargout = {x};
    
elseif ( nargout == 2 )
    
    varargout = {x(1), x(2)};

end

end

% disc is not a nested function this time so we need to pass the arguments
% into it
function y = disc(x1, x2, x3)

y = sqrt(x2^2 - 4*x1*x3);

end
