function coeffs = coscoeffs(n)
%COSCOEFFS Computes expansion coefficients c_0, c_1, ... c_n of cos(x).
% Mohsin Javed, Oct 6, 2015

% Initialize coefficients:
coeffs = zeros(n+1,1);

%% Loop version:

% Only fill in the even order coefficients, rest are zero:
for k = 0:2:n
    % Matlab indexing starts at 1 so c_0 is stored in coeffs(1) and so on and
    % therefore we have coeffs(k+1) in the line below:
    coeffs(k+1) = (-1)^(k/2)/factorial(k);
end

%% Vectorized version:
% The problem can be solved in one line of Matlab!
%coeffs(1:2:n+1) = (-1).^(1/2*(0:2:n))./factorial(0:2:n);
