function x = quadform(a, b, c)
%QUADFORM   Compute the roots of a quadratic.
%   X = QUADFORM(A, B, C) returns the roots of A*X^2 + B*X + C = 0.
%
% Hadrien Montanelli and Behnam Hashemi, Sep. 2016.

% Compute disctiminant:
d = sqrt(b^2 - 4*a*c);

% First root:
x(1) = (-b - d)/(2*a);

% Second root:
x(2) = (-b + d)/(2*a);

end
