function f = fib(n)
%FIB    Returns the nth Fibonacci number.
%
% Mohsin Javed, Oct 6, 2015.

% Need to treat n = 0, 1, 2 as special cases.
if ( n == 0 )
    f = 0;
    return;
end

if ( n <= 2 )
    f = 1;
    return;
end

% Initialize an array:
y = [ 1 1 0];
for k = 3:n
    % Definition of Fibonacci numbers:
    y(3) = y(1) + y(2);
    % Shift the Fibonacci numbers to the left:
    y(1) = y(2);
    y(2) = y(3);
end
% Output nth Fibonacci number:
f = y(3);

end
    
