function x = quadform2(a, b, c)
%QUADFORMF2   Compute the roots of a quadratic.
%   X = QUADFORMF2(A, B, C) returns the roots of A*X^2 + B*X + C = 0.
%
% Hadrien Montanelli and Behnam Hashemi, Sep. 2016.

% Compute disctiminant with DISC nested function:
d=disc;

% First root:
x(1) = (-b - d)/(2*a);

% Second root:
x(2) = (-b + d)/(2*a);

% disc is a nested function and automatically knows about the variables in
% the main function
    function y = disc
        y = sqrt(b^2 - 4*a*c);
    end

end
