function D2 = makeD2(N)
%MAKED2  Make a 2nd-order finite difference matrix.
%   MAKED2(N) returns a 2nd order finite difference matrix with periodic
%   boundary conditions.

D2 = (N/2)^2 * toeplitz([-2, 1, zeros(1, N-3) 1]);

% Note, it would be more efficient to construct a SPARSE() matrix. See
%   >> help spdiags
% for example.
%
% You can convert a full matrix to a sparse matrix, even though you have 
% already forced MATLAB to work out the full matrix. This can still be useful:
D2 = sparse(D2);

% You can convert it back to a full matrix (uncomment the next line to do so):
% D2 = full(D2);

end