% Find all the 'mirror primes' less than 100.
%
% Original creator: Nick Hale, Oct 2012
% Modified: Mohsin Javed, Oct 7, 2014.
% Last modified: MJ, Oct 6, 2015.

% Compute the primes between 10 and 100:
n = 100;
p = primes(n)'; 

% Primes less than 10 can't be mirrored! So delete them.
p(p<10) = [];

% Compute the mirrors of each of the primes:
q = 0*p;
for k = 1:length(p)
    a = floor(p(k)/10);  % compute tens digit of p
    b = p(k) - a*10;     % compute units digit of p
    q(k) = b*10 + a;
end

% Display these:
[p q]

% Find the mirrors which are also prime: 
idx = isprime(q);

% Extract these entries from the list of primes:
mirrorPrimes = [p(idx) q(idx)]

% Count them, i.e. length of one column of the array mirrorPrimes:
numel(mirrorPrimes(:,1)) 

% An interesting question is how does the number of mirror primes in [10, N]
% behave as N --> Infinity?
%ratio = sum(idx)/numel(p)

