function newton
%NEWTON   Compute a root of sin(x) + cos(x) using a Newton iteration.
%
% Original creator: Nick Hale, Oct 2011
% Modified: Mohsin Javed, Oct, 2014
% Last Modified: MJ, Oct, 2015

f = @(x) sin(x) + cos(x);           % The function
fp = @(x) cos(x) - sin(x);          % Its derivative
x = 6;                              % Initial guess
tol = 1e-10;                        % Tolerance

counter = 1; dx = inf; fx = f(x);     % Initialise variables

while ( abs(f(x)) > tol && abs(dx) > tol && counter < 10 )
    dx = f(x)/fp(x);                % Step
    x = x - dx;                     % Update
    counter = counter + 1;          % Counter
    fx(counter) = f(x);             % Store convergence
end

disp(x)                             % Display answer

semilogy(1:counter, abs(fx),'.-');  % Plot function values vs. iterations
shg

end
