%% A guide to Matlab publish
%
%% Introduction
%
% Matlab offers a very nice way to present work, combining code, comments,
% figures, etc. This facility, named publish, is a neat way to prepare
% assignments for handing in for this course. A short discussion follows. 
% We recommend that you look at both the .m file and the .html output to
% see which commands do what. 

%%
% If you are reading the .m file, then simply
% type "publish('publish_guide.m')" in the Matlab command window. This
% command will publish this file and once done, the command window will 
% display the path where the corresponding .html file has been generated. 
% Copy this path and paste it in the url bar of your favorite internet 
% browser (firefox for instance!) and see the published output. 

%% 
% If you are already reading this in .html format, we recommend that you
% open the .m file and publish it again to make sure that it works.
%
%% The use of %%
%
% If we start a line with %% Matlab's publish would consider that as a 
% signal to make a new "cell" for the code and comments that
% follow. Now there are two ways we
% can use %%. If we begin a line with %% and then write something
% afterwards on the same line, that something becomes the heading of a new 
% chapter and this chapter heading is added to the table of contents shown in the
% bginning of the published output. The chapter we are reading right now was created
% by writing "%% The use of %%" in the first line of this chapter. To create a new chapter 
% called "More on the use of %%", we say:

%% More on the use of %%

%%
% If on the other hand we only put %% in a line and then start our work
% from the next line with a single % in the beginning, this would generate
% a new paragraph/section. Here is an example:

%% Comments with %%
% Let us declare a variable x:
x = 1;
%%
% This is an important comment about x and it written with a %% line in the
% beginning, hence this does not appear as part of the code.

%% Comments without %%
% Let us declare a variable xx:
xx = linspace(-1,1, 101);
% This is an important comment about xx but written without a %% line in the
% beginning and hence it appears within the code block.


%% Results and figures
% A great benefit of using publish is the automatic inclusion of figures
% and calculation results in your files. Below we find the value of the
% 20th entry of the vector xx:
xx20 = xx(20) % Semicolon omitted, so, result will be shown in the output.
%%
% Figures get put in the correct place automatically:
plot(xx,sin(4*pi*xx),'--k'), title('sin(4\pix)')

%% Making Lists
% To make a numbered list, insert a blank line with a % and then for each
% item in the list start a new line with "% #" in the beginning. Here is an
% example:
% 
% # ITEM 1
% # ITEM 2
%%
% To make a bulleted list, use the same pattern but for each bullet 
% use "% *" in the beginning of each line. For example:
% 
% * ITEM1
% * ITEM2
%% How to publish in other formats
% Finally, it's worth mentioning that it's possible to publish in other
% format than .html, such as .tex. For changing the format and other
% options, from the Matlab editor, go to File -> Publish configuration for
% ... -> Edit publish configuration for ... or simply type "help publish"
% to see what other options are available.