%% Theory3:
% MSc MATLAB Crash Course: Graphics.
%
% Originally written by Asgeir Birkisson, Oct. 2015.
% Modified by Behnam Hashemi and Hadrien Montanelli, Sep. 2016.

%% Matlab offers various capabilities for plotting. For a simple plot, try:
x = linspace(-1, 1, 1000);
plot(x, sin(4*pi*x)),

%%
% To change the look of the line, see "doc linespec". Some examples
plot(x, sin(4*pi*x), 'r--') % Dashed red line
shg

%%
plot(x,sin(4*pi*x), 'k-.', 'LineWidth', 3) % Black dash-dot line, extra thick
shg

%%
% To impose another plot, use hold on:
hold on, plot(x, cos(2*pi*x), 'LineWidth', 2), hold off
shg

%%
% To make plots look nicer, one can add labels, titles, legends, ...
title('sin(4\pi x) and cos(2\pi x)','fontsize',16), 
xlabel('x','fontsize',30), ylabel('y')
legend('sin(4\pi x)','cos(2\pi x)'),
shg

%%
% We can also create figures with multiple plots using subplots
subplot(2,1,1), plot(x,sin(4*pi*x)),
subplot(2,1,2), plot(x,cos(2*pi*x))
shg

%%
% If the second argument of plot is a matrix, each column is plotted:
% figure()
x = linspace(0,10,100)';
M = [exp(x)  exp(2*x) exp(3*x)];
plot(x,M)

%%
% Third column dominates plot, use a logarithmic plot
semilogy(x,M)
shg
grid on % Display a grid

% See also, "help semilogx", "help loglog"

%% Can combine with a for loop?
x = linspace(-1,1,1000);
for freq = 1:4
    subplot(2,2,freq)
    plot(x, sin(pi*freq*x))
    title(['sin(', num2str(freq), '\pi x)'],'fontsize',16), 
end
shg

%% Animations
% figure
clf
for delta = 0 : 0.05 : 1
    plot(x, sin(pi*(x-delta)), 'linewidth', 4)
    title(['\delta = ' num2str(delta)], 'fontsize', 18)
    legend('sin(\pi(x-\delta))')
    pause(.1)
end

%% 3D plot of functions of two variables
% Start by creating a mesh grid
N = 40;
[X, Y] = meshgrid(linspace(-1,1,N), linspace(-2,2,N));
Z = X .* exp(-X.^2 - Y.^2);
surf(X, Y, Z)
% Now show mesh(X, Y, Z)
% the main difference is that this is a "filled solid" surface, compared 
% to mesh.
xlabel('x'), ylabel('y'), zlabel('z')

%%
[X, Y] = meshgrid(0:0.05:pi, 0:0.05:pi);
Z = sin(Y.^2+X) - cos(Y-X.^2);
surf(X, Y, Z)
xlabel('x'), ylabel('y'), zlabel('z')
shg

%% Set color shading properties
shading interp 
shg

%% contour plot 
% A contour line is a curve along which the function has a constant value.
contour(X, Y, Z)
shg

%% SURFace plot plus Contour lines
surfc(X, Y, Z), shg
%meshc(X, Y, Z), shg