%% A Matlab editor example
%

%% Cleaning the Matlab environment before starting to work is important!

clear; hold off; close all; clc; % this line just clears the environment

%% First section: define variables

syms x
x = sym('x'); % these two commands are the same
f = sqrt(1 - x^2);

% If you do not know what a function does, ask for help!
help sqrt

% If you still do not know: use Google (seriously!)!

%% Second section: plotting

% Can plot f like this...
fplot(f) 
axis([-1,1,0,1]) % set axes
shg % brings current figure to front
%pause % waits for user input

% ... or like this
xx = linspace(-1,1,1000);
ff = @(xx)sqrt(1 - xx.^2);
plot(xx,ff(xx), 'r-') 
axis([-1,1,0,1]) % set axes
shg % brings current figure to front

%% Third section: let's have some (Maths) fun!

H1 = fimplicit(@(x,y) x.^2 + (y - (-x).^(2/3)).^2 - 1, [-1.8,1.8]);
set(H1, 'Color', 'red','LineWidth', 3)
% with hold on we can plot multiple graphs on the same figure,
% but remember to run 'hold off' if you want to clean the figure
hold on 
H2 = fimplicit(@(x,y) x.^2 + (y - x.^(2/3)).^2 - 1, [-1.8,1.8]);
set(H2, 'Color', 'red','LineWidth', 3)
title('We <3 Maths')
shg 

%% Using LaTeX Maths
% We can also use LaTeX to include Maths (advanced)
%
% $$f = \sqrt{1-x^2}$$
%

%% You can also call scripts from a script

clean; % this is a script I wrote (see next)

%% Including external scripts to the published file
% <include>clean.m</include>
%

%% For extra info
% * Look at the publish guide in publish_guide.m
% * See also:
%   <https://www.mathworks.com/help/matlab/matlab_prog/marking-up-matlab-comments-for-publishing.html>
