function example_Dirichlet()

L=1;
T0=1;
T1=2;
kappa=0.01;

x=linspace(0,L,200);

figure(1);
set(gcf,'Position',[0 0 600 424],'Color','w');
clf; box on; hold on;
for t=[0.01 0.1 0.5 1 2 5 10 15 20 100]
    T=T0*(1-x/L)+T1*x/L;
    for n=1:100
        T=T+2/pi*1/n*(-T0+(-1)^n*T1)*sin(n*pi*x/L)*exp(-n^2*pi^2*kappa*t/L^2);
    end
    plot(x,T,'k-','Linewidth',1.25);
end
axis([-inf inf 0 2])
xlabel('x/L');
ylabel('T(x,t)/T^*');