function example_heatconduction()

L=1;
L1=0.2;
L2=0.4;

kappa = 1;

x=linspace(0,L,1000);

figure(1);
set(gcf,'Position',[0 0 600 424],'Color','w');

clf; box on; hold on;
for t=[0 0.25 0.5 1 2 4 8 16 32]/100
    T=0;
    for n=1:100
        T=T+2/pi*1/n*(cos(n*pi*L1/L)-cos(n*pi*L2/L))*sin(n*pi*x/L)*exp(-n^2*pi^2*kappa*t/L^2);
    end
    plot(x,T,'k-','Linewidth',1.25)
end
grid on;

axis([-inf inf -0.2 1.2]);
xlabel('x/L');
ylabel('T(x,t)/T^*');

x=linspace(0,L,10000);

figure(2);
set(gcf,'Position',[700 0 600 424],'Color','w');

clf; box on; hold on;
for t=[0 1e-5 1e-4 1e-3]
    T=0;
    for n=1:100
        T=T+2/pi*1/n*(cos(n*pi*L1/L)-cos(n*pi*L2/L))*sin(n*pi*x/L)*exp(-n^2*pi^2*kappa*t/L^2);
    end
    plot(x,T,'k-','Linewidth',1.25)
end
grid on;

axis([0.2 0.4 0.9 1.1]);
xlabel('x/L');
ylabel('T(x,t)/T^*');

