function example_modes_weighted_movie()

pause on

L=1;
c=5;
alpha = 1;
fun = @(theta) tan(theta)-alpha/theta;
omega1 = fzero(fun,[0.01,pi/2-0.01])/L;
omega2 = fzero(fun,[pi,3*pi/2-0.01])/L;
omega3 = fzero(fun,[2*pi,5*pi/2-0.01]/L);
omega4 = fzero(fun,[3*pi,7*pi/2-0.01]/L);
xm=linspace(-L,0,200);
xp=linspace(0,L,200);

figure(2);
set(gcf,'Position',[300 300 848 1200],'Color','w');

for t=0:0.01:4
    
    subplot(4,1,1);
    ym=sin(omega1*(L+xm))*sin(omega1*c*t);
    yp=sin(omega1*(L-xp))*sin(omega1*c*t);
    plot([xm,xp],[ym,yp],'k-','LineWidth',1.25');
    axis([-inf inf -1 1])
    box on;
    grid on;
    xlabel('x/L');
    ylabel('y/y_*');
    
    subplot(4,1,2);
    ym=sin(omega2*(L+xm))*sin(omega2*c*t);
    yp=sin(omega2*(L-xp))*sin(omega2*c*t);
    plot([xm,xp],[ym,yp],'k-','LineWidth',1.25');
    axis([-inf inf -1 1])
    box on;
    grid on;
    xlabel('x/L');
    ylabel('y/y_*');
    
    subplot(4,1,3);
    ym=sin(omega3*(L+xm))*sin(omega3*c*t);
    yp=sin(omega3*(L-xp))*sin(omega3*c*t);
    plot([xm,xp],[ym,yp],'k-','LineWidth',1.25');
    axis([-inf inf -1 1])
    box on;
    grid on;
    xlabel('x/L');
    ylabel('y/y_*');
    
    subplot(4,1,4);
    ym=sin(omega4*(L+xm))*sin(omega4*c*t);
    yp=sin(omega4*(L-xp))*sin(omega4*c*t);
    plot([xm,xp],[ym,yp],'k-','LineWidth',1.25');
    axis([-inf inf -1 1])
    box on;
    grid on;
    xlabel('x/L');
    ylabel('y/y_*');
    pause(1e-3);
end
