#include "cfl/Similar.hpp"
#include "cfl/Slice.hpp"

using namespace cfl;
using namespace std;

namespace cflSimilar
{
    class SimilarModel : public IModel
    {
    public:
        SimilarModel(ISimilarRollback *pNewRollback)
            : m_pRollback(pNewRollback) {}

        const IModel &model() const
        {
            return m_pRollback->model();
        }

        const std::vector<double> &eventTimes() const
        {
            return model().eventTimes();
        }

        unsigned numberOfStates() const
        {
            return model().numberOfStates();
        }

        Slice state(unsigned iTime, unsigned iState) const
        {
            Slice uState = model().state(iTime, iState);
            uState.assign(*this);
            return uState;
        }

        unsigned numberOfNodes(unsigned iTime, const std::vector<unsigned> &rDependence) const
        {
            return model().numberOfNodes(iTime, rDependence);
        }

        std::valarray<double> origin() const
        {
            return model().origin();
        }

        void addDependence(Slice &rSlice, const std::vector<unsigned> &rDependence) const
        {
            rSlice.assign(model());
            model().addDependence(rSlice, rDependence);
            rSlice.assign(*this);
        }

        void rollback(Slice &rSlice, unsigned iTime) const
        {
            rSlice.assign(model());
            m_pRollback->rollback(rSlice, iTime);
            rSlice.assign(*this);
        }

        void indicator(Slice &rSlice, double dBarrier) const
        {
            rSlice.assign(model());
            model().indicator(rSlice, dBarrier);
            rSlice.assign(*this);
        }

        MultiFunction interpolate(const Slice &rSlice) const
        {
            Slice uSlice(rSlice);
            uSlice.assign(model());
            return model().interpolate(uSlice);
        }

    private:
        std::shared_ptr<ISimilarRollback> m_pRollback;
    };

} // namespace cflSimilar

// class Similar

cfl::Similar::Similar(ISimilarRollback *pNewRollback)
    : m_pModel(new cflSimilar::SimilarModel(pNewRollback)) {}

void cfl::Similar::assign(ISimilarRollback *pNewSimilarRollback)
{
    m_pModel.reset(new cflSimilar::SimilarModel(pNewSimilarRollback));
}