#include "test/Main.hpp"
#include "test/Black.hpp"
#include "test/Print.hpp"
#include "Homework3/Output.hpp"
#include "Homework3/Homework3.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Black;

MultiFunction straddle(AssetModel &rModel)
{
  test::print("EUROPEAN STRADDLE OPTION IN ASSET MODEL");

  double dStrike = test::Black::c_dSpot;
  double dMaturity = test::Black::c_dMaturity;

  print(dStrike, "strike");
  print(dMaturity, "maturity", true);

  return prb::straddle(dStrike, dMaturity, rModel);
}

MultiFunction
americanCallOnForward(AssetModel &rModel)
{
  test::print("AMERICAN CALL ON FORWARD IN ASSET MODEL");

  double dForwardPrice = test::Black::c_dSpot;
  double dTimeToMaturity = 0.5;
  const std::vector<double> uExerciseTimes = test::Black::exerciseTimes();

  print(dForwardPrice, "forward price");
  print(dTimeToMaturity, "time to maturity", true);
  test::print(uExerciseTimes.begin(), uExerciseTimes.end(), "exercise times");

  return prb::americanCallOnForward(dForwardPrice, dTimeToMaturity,
                                    uExerciseTimes, rModel);
}

MultiFunction downRebate(AssetModel &rModel)
{
  test::print("DOWN-AND-REBATE OPTION IN ASSET MODEL");

  double dLowerBarrier = test::Black::c_dSpot * 0.9;
  double dNotional = test::Black::c_dNotional;
  const std::vector<double>
      uBarrierTimes = test::Black::barrierTimes();

  print(dLowerBarrier, "lower barrier");
  print(dNotional, "notional", true);
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::downRebate(dLowerBarrier,
                         dNotional, uBarrierTimes, rModel);
}

MultiFunction upInAmericanPut(AssetModel &rModel)
{
  test::print("UP-AND-IN AMERICAN PUT OPTION IN ASSET MODEL");

  double dStrike = test::Black::c_dSpot;
  const std::vector<double> uExerciseTimes = test::Black::exerciseTimes();
  double dUpperBarrier = test::Black::c_dSpot * 1.1;
  const std::vector<double> uBarrierTimes = test::Black::barrierTimes();

  print(dStrike, "strike");
  print(dUpperBarrier, "upper barrier", true);
  test::print(uExerciseTimes.begin(), uExerciseTimes.end(), "exercise times");
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::upInAmericanPut(dUpperBarrier, uBarrierTimes, dStrike,
                              uExerciseTimes, rModel);
}

std::function<void()> test_Homework3()
{
  return []() {
    print("OPTIONS ON A SINGLE STOCK IN BLACK MODEL");

    AssetModel uModel = test::Black::model();

    report(straddle, uModel);
    report(americanCallOnForward, uModel);
    report(downRebate, uModel);
    report(upInAmericanPut, uModel);
  };
}

int main()
{
  project(test_Homework3(), PROJECT_NAME, PROJECT_NAME,
          "Homework 3");
}
