#include "test/Main.hpp"
#include "test/Data.hpp"
#include "test/Print.hpp"
#include "test/Black.hpp"
#include "test/HullWhite.hpp"
#include "SampleExam2/Output.hpp"
#include "SampleExam2/SampleExam2.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Data;

void volatilityVarLinInterp()
{
  test::print("VOLATILITY CURVE BY LINEAR INTERPOLATION OF VARIANCE CURVE");
  
  double dInitialTime = 1.;
  auto uV = test::Data::getVol(dInitialTime);
  
  Function uResult =
    prb::volatilityVarLinInterp(uV.first, uV.second, dInitialTime);
  double dInterval = uV.first.back() - dInitialTime;
  test::Data::print(uResult, dInitialTime, dInterval);
}

const std::string c_sDF("Fitted discount factors and their errors:");

void discountHullWhiteFit()
{
  test::print("LEAST-SQUARES FIT OF DISCOUNT CURVE FOR HULL AND WHITE MODEL");

  double dLambda = 0.05;
  double dInitialTime = 1.;

  print(dLambda, "lambda");
  auto uDF = test::Data::getDiscount(dInitialTime);

  Function uErr;
  FitParam uParam;
  Function uDiscount =
    prb::discountHullWhiteFit(uDF.first, uDF.second,
			      dLambda, dInitialTime, uErr, uParam);
  double dInterval = uDF.first.back() - dInitialTime;
  test::Data::printFit(uParam);
  test::Data::print(c_sDF, uDiscount, uErr, dInitialTime, dInterval);
}

MultiFunction boost(AssetModel &rModel)
{
  test::print("BOOST OPTION IN ASSET MODEL");

  double dNotional = test::Black::c_dNotional;
  double dLowerBarrier = test::Black::c_dSpot * 0.95;
  double dUpperBarrier = test::Black::c_dSpot * 1.1;
  const std::vector<double> uBarrierTimes = test::Black::exerciseTimes();

  print(dNotional, "notional");
  print(dLowerBarrier, "lower barrier");
  print(dUpperBarrier, "upper barrier", true);
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::boost(dNotional, dLowerBarrier, dUpperBarrier,
                    uBarrierTimes, rModel);
}

cfl::MultiFunction resetCouponPutBond(InterestRateModel &rModel)
{
  test::print("PUTABLE BOND WITH RESETTABLE COUPON IN INTEREST RATE MODEL");

  cfl::Data::CashFlow uBondParameters = test::HullWhite::swapParameters();
  double dResetCouponRate = uBondParameters.rate - 0.02;
  double dRedemptionPrice = 0.98;

  test::printCashFlow(uBondParameters, "bond parameters");
  print(dResetCouponRate, "reset value for coupon rate");
  print(dRedemptionPrice, "redemption price (percent of notional)", true);

  return prb::resetCouponPutBond(uBondParameters, dResetCouponRate,
				 dRedemptionPrice, rModel);
}

std::function<void()> test_SampleExam2()
{
  return []() {
	   print("INTERPOLATION OF DATA CURVES");
	   
	   volatilityVarLinInterp();
	   
	   print("LEAST SQUARE FITTING OF DATA CURVES");

	   discountHullWhiteFit();

	   print("OPTIONS ON A SINGLE STOCK IN BLACK MODEL");

	   AssetModel uBlack = test::Black::model();
	   test::Black::report(boost,uBlack);

	   print("INTEREST RATE OPTIONS IN HULL-WHITE MODEL");

	   InterestRateModel uHullWhite = test::HullWhite::model();
	   test::HullWhite::report(resetCouponPutBond, uHullWhite);
	 };
}

int main()
{
  project(test_SampleExam2(), PROJECT_NAME, PROJECT_NAME,
          "SampleExam2");
}
