#include "test/Main.hpp"
#include "test/HullWhite.hpp"
#include "test/Print.hpp"
#include "Session4/Output.hpp"
#include "Session4/Session4.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::HullWhite;

cfl::MultiFunction floor(InterestRateModel &rModel)
{
  test::print("FLOOR IN INTEREST RATE MODEL");

  cfl::Data::CashFlow uFloorParameters = test::HullWhite::swapParameters();
  uFloorParameters.rate = test::HullWhite::c_dYield * 0.9;

  test::printCashFlow(uFloorParameters, "floor parameters");

  return prb::floor(uFloorParameters, rModel);
}

cfl::MultiFunction putOnFRA(InterestRateModel &rModel)
{
  test::print("PUT ON FORWARD RATE AGREEMENT IN INTEREST RATE MODEL");

  double dFixedRate = test::HullWhite::c_dYield;
  double dPeriod = test::HullWhite::c_dPeriod;
  double dNotional = test::HullWhite::c_dNotional;
  double dMaturity = test::HullWhite::c_dMaturity;

  print(dMaturity, "maturity");
  print(dFixedRate, "fixed rate");
  print(dPeriod, "period for FRA");
  print(dNotional, "notional", true);

  return prb::
      putOnFRA(dFixedRate, dPeriod, dNotional, dMaturity, rModel);
}

cfl::MultiFunction capOnSwapRate(InterestRateModel &rModel)
{
  test::print("CAP ON SWAP RATE IN INTEREST RATE MODEL");

  cfl::Data::CashFlow uCapParameters = test::HullWhite::swapParameters();
  uCapParameters.rate = test::HullWhite::c_dYield * 1.1;
  double dSwapPeriod = uCapParameters.period * 2;
  unsigned iSwapPayments = uCapParameters.numberOfPayments * 2;

  test::printCashFlow(uCapParameters, "cap parameters");
  print(dSwapPeriod, "swap period");
  print(iSwapPayments, "number of swap payments", true);

  return prb::
      capOnSwapRate(uCapParameters, dSwapPeriod, iSwapPayments, rModel);
}

cfl::MultiFunction
cancelSwapArrears(InterestRateModel &rModel, bool bPayFloat)
{
  test::print("CANCELLABLE SWAP SET IN ARREARS IN INTEREST RATE MODEL");

  Data::Swap uSwap = test::HullWhite::swapParameters();
  uSwap.payFloat = bPayFloat;

  test::printSwap(uSwap, "swap parameters");

  return prb::cancelSwapArrears(uSwap, rModel);
}

std::function<void()> test_Session4()
{
  return []() {
    print("INTEREST RATE OPTIONS IN HULL-WHITE MODEL");

    InterestRateModel uModel = test::HullWhite::model();

    report(floor, uModel);
    report(putOnFRA, uModel);
    report(capOnSwapRate, uModel);
    report(cancelSwapArrears, uModel);
  };
}

int main()
{
  project(test_Session4(), PROJECT_NAME, PROJECT_NAME,
          "Session 4");
}
