#include "Examples/Examples.hpp"
#include "cfl/Macros.hpp"
#include <cmath>

using namespace cfl;
using namespace cfl::Data;

cfl::Function prb::yieldShape1(double dLambda, double dInitialTime)
{
  std::function<double(double)> uShape =
      [dLambda, dInitialTime](double dT) {
        double dX = std::max(dLambda * (dT - dInitialTime), cfl::EPS);
        return (1 - std::exp(-dX)) / dX;
      };
  return Function(uShape, dInitialTime);
}

cfl::Function prb::yieldShape2(double dLambda, double dInitialTime)
{
  std::function<double(double)> uShape =
      [dLambda, dInitialTime](double dT) {
        double dX = std::max(dLambda * (dT - dInitialTime), cfl::EPS);
        return (1 - std::exp(-dX)) / dX - std::exp(-dX);
      };
  return Function(uShape, dInitialTime);
}
