/**
 * @file   Index.hpp
 * @author Dmitri Kramkov <kramkov@cmu.edu>
 * @brief  The index page of the documentation. Does not contain any code. 
 * @version 1.0
 * @date 2021-01-12
 * 
 * @copyright Copyright (c) 2020
 */


/**
 * \mainpage Library for the course "Financial Computing with C++"
 * 
 * <b>CFL</b> (<b>Library</b> for the course <b>Financial Computing</b> with C++) is
 * a part of the course package. We shall use it to achieve the goals
 * of the course:
 * 
 * <dl>
 * <dt> "Theoretical":</dt> 
 * <dd> Discuss the design and implementation of a
 * powerful C++ library for pricing of derivative securities. 
 * <dt> "Practical":</dt> 
 * <dd> Use <b>cfl</b> library for practical financial
 * computations.
 * </dl>
 * 
 * \remark The library is intended only for the course. No guarantee
 * whatsoever is given with respect to the accuracy of the results.
 *
 * \author Dmitry Kramkov, Carnegie Mellon; <a
 * href="mailto:kramkov@cmu.edu">kramkov@cmu.edu</a>.
 * 
 */

/**
 * @defgroup cflNumeric Numerical methods.
 * This module contains numerical routines used in implementations
 * of financial models. 
 */
