#include "cfl/Data.hpp"
#include "test/Black.hpp"
#include "test/Output.hpp"

using namespace cfl;
using namespace std;
using namespace test;
using namespace cfl::Black;

cfl::Black::Data
test::Black::data(double dYield, double dSpot,
                  double dDividendYield, double dSigma,
                  double dLambda, double dInitialTime)
{
  print("PARAMETERS OF BLACK MODEL:");
  print(dYield, "interest rate");
  print(dSpot, "spot price");
  print(dDividendYield, "convenience yield");
  print(dSigma, "sigma");
  print(dLambda, "lambda");
  print(dInitialTime, "initial time", true);

  cfl::Function uDiscount = cfl::Data::discount(dYield, dInitialTime);
  cfl::Function uForward = cfl::Data::forward(dSpot, dDividendYield, uDiscount,
                                              dInitialTime);
  return cfl::Black::Data(uDiscount, uForward, dSigma, dLambda, dInitialTime);
}

cfl::AssetModel test::Black::model(double dQuality)
{
  cfl::Black::Data uData = test::Black::data();
  print(dQuality, "quality", true);
  return cfl::Black::model(uData, c_dInterval, dQuality);
}

namespace testBlack
{
  void print(const cfl::Function &rOption, double dSpot,
             double dInterval, unsigned iPoints)
  {
    test::print("OPTION VALUES VERSUS SPOT:");

    PRECONDITION(dInterval > 0.);
    PRECONDITION(iPoints > 0);
    unsigned iSize = 2 * (iPoints / 2) + 1;
    std::vector<double> uSpot(iSize);
    std::vector<double> uOption(iSize);

    double dX = -dInterval / 2.;
    double dStep = dInterval / (iSize - 1.);
    for (unsigned iI = 0; iI < iSize; iI++)
    {
      uSpot[iI] = ::exp(dX) * dSpot;
      uOption[iI] = rOption(dX);
      dX += dStep;
    }

    unsigned iSpot = 8;
    unsigned iSpace = 6;
    unsigned iOption = 12;

    std::cout << std::setw(iSpot) << "spot"
              << std::setw(iSpace) << ""
              << std::setw(iOption) << "option" << endl;
    for (unsigned iI = 0; iI < iSize; iI++)
    {
      std::cout << std::setw(iSpot) << uSpot[iI]
                << std::setw(iSpace) << ""
                << std::setw(iOption) << uOption[iI] << endl;
    }
    std::cout << endl;
  }

  void print(const cfl::MultiFunction &rOption, double dSpot,
             double dInterval, unsigned iPoints)
  {
    PRECONDITION(rOption.dim() == 1);
    cfl::Function uOption = cfl::toFunction(rOption);
    print(uOption, dSpot, dInterval, iPoints);
  }

} // namespace testBlack

void test::Black::
    report(MultiFunction (*f)(AssetModel &rModel), AssetModel &rModel)
{
  Function uOption = toFunction(f(rModel));
  printRisk(uOption);
  testBlack::print(uOption, c_dSpot, c_dInterval, c_iPoints);
}

void test::Black::
    report(MultiFunction (*f)(AssetModel &rModel, bool bPayFloat),
           AssetModel &rModel)
{
  for (unsigned i = 0; i < 2; i++)
  {
    bool bPayFloat = (i == 0) ? true : false;
    Function uOption = toFunction(f(rModel, bPayFloat));
    printRisk(uOption);
    testBlack::print(uOption, c_dSpot, c_dInterval, c_iPoints);
  }
}
