#ifndef __Homework1_hpp__
#define __Homework1_hpp__

/**
 * @file Homework1.hpp
 * @author Dmitry Kramkov (kramkov@andrew.cmu.edu)
 * @brief Homework 1: data curves for financial models
 * @version 0.1
 * @date 2021-02-12
 * 
 * @copyright Copyright (c) 2021
 * 
 */

#include "cfl/Data.hpp"

/**
 * @mainpage Homework 1: data curves for financial models
 */

namespace prb
{
  /** 
   * @defgroup prbData Data structures. 
   *
   * This module constructs input data curves for financial models. 
   * @{
   */

  /**
   * Computes volatility curve \f$\Sigma = \Sigma(t)\f$ from 
   * variance curve \f$V = V(t)\f$:
   * \f[
   * V(t) = \Sigma^2(t)(t-t_0), \quad t\geq t_0. 
   * \f]
   * 
   * @param rVar (\f$V(t)\f$) The variance function. 
   * @param dInitialTime  (\f$t_0\f$) The initial time. 
   * @return cfl::Function The volatility curve. 
   */
  cfl::Function volatilityVar(const cfl::Function &rVar, double dInitialTime);

  /** 
   * Computes cost-of-carry rate curve \f$c=(c(t))_{t\geq t_0}\f$
   * for the Black model. In this model, the log of spot
   * price evolves as
   * \f[
   * \log S_t = \log S(t_0) + X_t, \quad t\geq t_0, 
   * \f]
   * where \f$X=(X_t)\f$ is an OU (Ornstein-Uhlenbeck) process 
   * driven by Brownian motion \f$B=(B_t)\f$:  
   * \f[
   *    dX_t =  (\theta - \lambda X_t) dt + \sigma dB_t,  
   *  \quad X(t_0) = 0.  
   * \f]
   * We recall that the forward price curve has the form: 
   * \f[
   * F(t) = S(t_0) \exp(c(t)(t-t_0)), \quad t\geq t_0.  
   * \f]
   *
   * @param dTheta (\f$\theta\f$) The drift term. 
   * @param dLambda (\f$\lambda\geq 0\f$) The mean reversion level. 
   * @param dSigma  (\f$\sigma\geq 0\f$) The volatility.  
   * @param dInitialTime (\f$t_0\f$) The initial time. 
   * 
   * @return The cost-of-carry rate curve in Black model.
   */
  cfl::Function
  carryBlack(double dTheta, double dLambda, double dSigma,
             double dInitialTime);

  /** 
   * Computes yield curve \f$\gamma=\gamma(t)\f$ for the Svensson
   * model:
   * \f[
   *  \gamma(t) = c_0 + c_1 \frac{1-e^{-\lambda_1(t-t_0)}}{\lambda_1 (t-t_0)} +
   *  c_2 \left(\frac{1-e^{-\lambda_1(t-t_0)}}{\lambda_1 (t-t_0)}  -
   *     e^{-\lambda_1 (t-t_0)}\right) +
   *  c_3 \left(\frac{1-e^{-\lambda_2(t-t_0)}}{\lambda_2 (t-t_0)}  -
   *     e^{-\lambda_2 (t-t_0)}\right) , \quad t\geq t_0. 
   * \f]
   *
   * @param dC0 (\f$c_0\f$) The first constant
   * @param dC1 (\f$c_1\f$) The second constant. 
   * @param dC2 (\f$c_2\f$) The third constant. 
   * @param dC3 (\f$c_3\f$) The fourth constant. 
   * @param dLambda1 (\f$\lambda_1>0\f$) The first mean-reversion rate. 
   * @param dLambda2 (\f$\lambda_2>0\f$) The second mean-reversion
   * rate, \f$\lambda_1\not=\lambda_2\f$. 
   * @param dInitialTime (\f$t_0\f$) The initial time. 
   * 
   * @return The yield curve for the Svensson model. 
   */
  cfl::Function
  yieldSvensson(double dC0, double dC1, double dC2, double dC3,
                double dLambda1, double dLambda2, double dInitialTime);

  /** 
   * Computes the curve of forward prices ("clean" or "dirty") for a
   * coupon bond. The bond pays coupons \f$q\delta t\f$ at times
   * \f$(t_i)_{i=1,\dots,M}\f$ such that 
   * \f[
   *     t_0 < t_1 \leq t_0+\delta t, \quad t_{i+1}-t_i= \delta t, \quad
   *     t_M = T.
   * \f]
   * The bond also pays notional \f$N=1\f$ at maturity \f$T\f$. The buyer of
   * the forward contract pays forward price \f$F(t)\f$ at delivery time
   * \f$t\f$ and then receives coupons \f$q\delta t\f$ at payments times
   * \f$t_i>t\f$ and notional \f$N=1\f$ at maturity \f$T\f$.

   * 
   * @param dRate  (\f$q\f$) The coupon rate. 
   * @param dPeriod  (\f$\delta t\f$) The time interval between payments. 
   * @param dMaturity  (\f$T\f$) The maturity. 
   * @param rDiscount The discount curve. 
   * @param dInitialTime (\f$t_0\f$) The initial time. 
   * @param bClean This parameter controls the output. If its value
   * is \p true, then we compute "clean" prices. Otherwise, we
   * compute "dirty" prices that include the accrued interest from
   * the next coupon. 
   * 
   * @return The forward price ("clean" or "dirty") curve for the coupon
   * bond. 
   */
  cfl::Function forwardCouponBond(double dRate, double dPeriod, double dMaturity,
                                  const cfl::Function &rDiscount,
                                  double dInitialTime, bool bClean);
  /** @} */  
}

#endif // of __Homework1_hpp__
