#include "test/Main.hpp"
#include "test/Data.hpp"
#include "test/Print.hpp"
#include "test/Black.hpp"
#include "test/HullWhite.hpp"
#include "SampleExam1/Output.hpp"
#include "SampleExam1/SampleExam1.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Data;

void yieldVasicek()
{
  test::print("YIELD CURVE IN VASICEK MODEL");

  double dLambda = 0.05;
  double dTheta = 0.02;
  double dR0 = 0.04;
  double dSigma = 0.01;
  double dInitialTime = 1.5;

  print(dTheta, "theta");
  print(dLambda, "lambda");
  print(dSigma, "sigma");
  print(dR0, "r_0");
  print(dInitialTime, "initial time", true);

  Function uYield =
    prb::yieldVasicek(dTheta, dLambda, dSigma, dR0, dInitialTime);
  double dInterval = 5;
  test::Data::print(uYield, dInitialTime, dInterval);
}

void forwardFXLogLinInterp()
{
  test::print("FORWARD EXCHANGE CURVE BY LOG-LINEAR INTERPOLATION");

  double dSpotFX = 100;
  double dInitialTime = 1.;

  auto uDF = test::Data::getDiscountFX(dSpotFX, dInitialTime);

  Function uForwardFX =
    prb::forwardFXLogLinInterp(dSpotFX, get<0>(uDF), get<1>(uDF),
			       get<2>(uDF), dInitialTime);

  double dInterval = get<0>(uDF).front() - dInitialTime;
  test::Data::print(uForwardFX, dInitialTime, dInterval);
}

MultiFunction upRangeOutPut(AssetModel &rModel)
{
  test::print("UP-RANGE-OUT PUT OPTION IN ASSET MODEL");

  double dStrike = test::Black::c_dSpot;
  double dMaturity = test::Black::c_dMaturity;
  double dUpperBarrier = test::Black::c_dSpot * 1.02;
  const std::vector<double> uBarrierTimes = test::Black::barrierTimes();
  unsigned iOutTimes = std::min<int>(uBarrierTimes.size(), 4);

  print(dStrike, "strike");
  print(dMaturity, "maturity");
  print(dUpperBarrier, "upper barrier");
  print(iOutTimes, "number of barrier events needed to cancel put", true);
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::upRangeOutPut(dUpperBarrier, iOutTimes,
                            uBarrierTimes, dStrike, dMaturity,
                            rModel);
}

cfl::MultiFunction futuresOnCheapToDeliver(InterestRateModel &rModel)
{
  test::print("FUTURES PRICE OF CHEAPEST TO DELIVER COUPON BOND IN INTEREST RATE MODEL");

  double dFuturesMaturity = 0.5;
  unsigned iNumberOfFuturesTimes = 20;

  print(dFuturesMaturity, "maturity of futures contract");
  print(iNumberOfFuturesTimes, "number of futures times", true);

  unsigned iNumberOfBonds = 5;
  std::vector<cfl::Data::CashFlow> uBonds(iNumberOfBonds);
  double dNotional = test::HullWhite::c_dNotional;
  double dRate = test::HullWhite::c_dYield;
  double dPeriod = 0.25;
  unsigned iNumberOfPeriods = 4;
  for (unsigned i = 0; i < iNumberOfBonds; i++)
    {
      cout << "Bond " << i << ":" << endl;
      uBonds[i].notional = dNotional;
      cout << "notional = " << uBonds[i].notional << endl;
      uBonds[i].rate = dRate;
      cout << "coupon rate = " << uBonds[i].rate << endl;
      uBonds[i].period = dPeriod;
      cout << "period = " << uBonds[i].period << endl;
      uBonds[i].numberOfPayments = iNumberOfPeriods + i;
      cout << "number of payments = " << uBonds[i].numberOfPayments << endl
	   << endl;
    }
  return prb::
    futuresOnCheapToDeliver(dFuturesMaturity, iNumberOfFuturesTimes,
			    uBonds, rModel);
}

std::function<void()> test_SampleExam1()
{
  return []() {
	   print("DATA CURVES FOR FINANCIAL MODELS");

	   yieldVasicek();

	   print("INTERPOLATION OF DATA CURVES");

	   forwardFXLogLinInterp();

    	   print("OPTIONS ON A SINGLE STOCK IN BLACK MODEL");

	   AssetModel uBlack = test::Black::model();
	   test::Black::report(upRangeOutPut,uBlack);

	   print("INTEREST RATE OPTIONS IN HULL-WHITE MODEL");

	   InterestRateModel uHullWhite = test::HullWhite::model();
	   test::HullWhite::report(futuresOnCheapToDeliver, uHullWhite);
	 };
}

int main()
{
  project(test_SampleExam1(), PROJECT_NAME, PROJECT_NAME,
          "SampleExam1");
}
