#include "test/Main.hpp"
#include "test/Data.hpp"
#include "test/Print.hpp"
#include "test/Black.hpp"
#include "test/HullWhite.hpp"
#include "SampleExam3/Output.hpp"
#include "SampleExam3/SampleExam3.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Data;

void discountSwapLogLinInterp()
{
  test::print("DISCOUNT CURVE FROM SWAP RATES BY LOG LINEAR INTERPOLATION");

  double dInitialTime = 1.;
  double dPeriod = 0.5;
  
  std::vector<double> uR = test::Data::getSwapRates(dPeriod, dInitialTime);
    
  Function uDiscount =
    prb::discountSwapLogLinInterp(uR, dPeriod, dInitialTime);

  double dInterval = uR.size() * dPeriod / 1.1;
  test::Data::print(uDiscount, dInitialTime + 0.001, dInterval);
}

const std::string c_sForwardFX("Fitted forward exchange rates and their errors:");

void forwardFXSvenssonFit()
{
  test::print("LEAST-SQUARES FIT OF FORWARD EXCHANGE CURVE IN SVENSSON MODEL");

  double dSpotFX = 100;
  double dLambda1 = test::Black::c_dLambda;
  double dLambda2 = dLambda1 * 1.2;
  double dInitialTime = 1.;

  print(dLambda1, "lambda 1");
  print(dLambda2, "lambda 2");
  auto uDF = test::Data::getDiscountFX(dSpotFX, dInitialTime);

  Function uErr;
  FitParam uParam;
  Function uForward =
    prb::forwardFXSvenssonFit(dSpotFX, get<0>(uDF), get<1>(uDF), get<2>(uDF),
			      dLambda1, dLambda2, dInitialTime,
			      uErr, uParam);
  double dInterval = get<0>(uDF).back() - dInitialTime;
  test::Data::printFit(uParam);
  test::Data::print(c_sForwardFX, uForward, uErr, dInitialTime, dInterval);
}

MultiFunction varianceSwapStrike(AssetModel &rModel)
{
  test::print("STRIKE OF VARIANCE SWAP IN ASSET MODEL");

  double dMaturity = test::Black::c_dMaturity;
  unsigned iNumberOfTimes = 12;

  print(dMaturity, "maturity");
  print(iNumberOfTimes, "number of variance times", true);
  
  return prb::varianceSwapStrike(dMaturity, iNumberOfTimes,
                                 rModel);
}

cfl::MultiFunction 
callableCappedFloater(InterestRateModel &rModel)
{
  test::print("CALLABLE CAPPED FLOATER IN INTEREST RATE MODEL");

  cfl::Data::CashFlow uCapParameters = test::HullWhite::swapParameters();
  uCapParameters.rate = test::HullWhite::c_dYield * 1.1;
  double dLiborSpread = 0.01;

  test::printCashFlow(uCapParameters, "cap parameters");
  print(dLiborSpread, "spread over LIBOR", true);

  return prb::
    callableCappedFloater(uCapParameters, dLiborSpread, rModel);
}

std::function<void()> test_SampleExam3()
{
  return []() {   
	   print("INTERPOLATION OF DATA CURVES");
    
	   discountSwapLogLinInterp();

	   print("LEAST SQUARE FITTING OF DATA CURVES");

	   forwardFXSvenssonFit();

	   print("OPTIONS ON A SINGLE STOCK IN BLACK MODEL");

	   AssetModel uBlack = test::Black::model();
	   test::Black::report(varianceSwapStrike,uBlack);

	   print("INTEREST RATE OPTIONS IN HULL-WHITE MODEL");

	   InterestRateModel uHullWhite = test::HullWhite::model();
	   test::HullWhite::report(callableCappedFloater, uHullWhite);
	 };
}

int main()
{
  project(test_SampleExam3(), PROJECT_NAME, PROJECT_NAME,
          "SampleExam3");
}
