#include "test/Main.hpp"
#include "test/Data.hpp"
#include "test/Print.hpp"
#include "Homework2/Output.hpp"
#include "Homework2/Homework2.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Data;

// INTERPOLATION OF DATA CURVES

void forwardFXCarryLinInterp()
{
  test::print("FORWARD EXCHANGE CURVE BY LINEAR INTERPOLATION OF COST-OF-CARRY RATES");

  double dSpotFX = 100;
  double dInitialTime = 1.;

  auto uDF = test::Data::getDiscountFX(dSpotFX, dInitialTime);

  Function uForwardFX =
    prb::forwardFXCarryLinInterp(dSpotFX, get<0>(uDF), get<1>(uDF),
				 get<2>(uDF), dInitialTime);

  double dInterval = get<0>(uDF).front() - dInitialTime;
  test::Data::print(uForwardFX, dInitialTime, dInterval);
}

void discountLogInterp()
{
  test::print("LOG INTERPOLATION OF DISCOUNT CURVE");

  double dInitialTime = 1.;

  auto uDF = test::Data::getDiscount(dInitialTime);

  Function uDiscount =
    prb::discountLogInterp(uDF.first, uDF.second,
			   dInitialTime, cfl::NInterp::steffen());

  double dInterval = uDF.first.back() - dInitialTime;
  test::print("log interpolation with Steffen method:");
  test::Data::print(uDiscount, dInitialTime, dInterval);
}

// LEAST SQUARE FITTING OF DATA CURVES

const std::string c_sVol("Fitted volatilities and their errors:");

void volatilityBlackFit()
{
  test::print("LEAST-SQUARES FIT OF VOLATILITY CURVE FOR BLACK MODEL");

  double dLambda = 0.05;
  double dInitialTime = 1.;

  print(dLambda, "lambda");
  auto uVol = test::Data::getVol(dInitialTime);

  FitParam uParam;
  Function uErr;
  Function uVolat =
      prb::volatilityBlackFit(uVol.first, uVol.second,
                              dLambda, dInitialTime, uErr, uParam);

  double dInterval = uVol.first.back() - dInitialTime;
  test::Data::printFit(uParam);
  test::Data::print(c_sVol, uVolat, uErr, dInitialTime, dInterval);
}

const std::string c_sDF("Fitted discount factors and their errors:");

void discountSvenssonFit()
{
  test::print("LEAST-SQUARES FIT OF DISCOUNT CURVE IN SVENSSON MODEL");

  double dLambda1 = 0.02;
  double dLambda2 = 0.1;
  double dInitialTime = 1.;

  print(dLambda1, "lambda1");
  print(dLambda2, "lambda2");
  auto uDF = test::Data::getDiscount(dInitialTime);

  Function uErr;
  FitParam uParam;
  Function uDiscount =
      prb::discountSvenssonFit(uDF.first, uDF.second,
                               dLambda1, dLambda2, dInitialTime,
                               uErr, uParam);
  double dInterval = uDF.first.back() - dInitialTime;
  test::Data::printFit(uParam);
  test::Data::print(c_sDF, uDiscount, uErr, dInitialTime, dInterval);
}

std::function<void()> test_Homework2()
{
  return []() {
	   print("INTERPOLATION OF DATA CURVES");
    
	   forwardFXCarryLinInterp();
	   discountLogInterp();    

	   print("LEAST SQUARE FITTING OF DATA CURVES");

	   volatilityBlackFit();
	   discountSvenssonFit();
	 };
}

int main()
{
  project(test_Homework2(), PROJECT_NAME, PROJECT_NAME,
          "Homework 2");
}
