#include "test/Main.hpp"
#include "test/Data.hpp"
#include "test/Print.hpp"
#include "test/HullWhite.hpp"
#include "Homework1/Output.hpp"
#include "Homework1/Homework1.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Data;

void volatilityVar()
{
  test::print("VOLATILITY CURVE FROM VARIANCE CURVE");

  double dInitialTime = 0.75;
  print(dInitialTime, "initial time", true);

  double dSigma = 0.25;

  Function uVol([dSigma, dInitialTime](double dT) {
    return dSigma*( 1. + (dT - dInitialTime));
  },
                dInitialTime);

  Function uVar([dInitialTime, uVol](double dT) {
    double dSigma = uVol(dT);
    return dSigma * dSigma * (dT - dInitialTime);
  },
                dInitialTime);

  Function uV = prb::volatilityVar(uVar, dInitialTime);
  Function uErr = cfl::abs(uV - uVol);

  double dInterval = 1.;
  test::Data::print("The result:", uV, uErr, dInitialTime, dInterval);
}

void carryBlack()
{
  test::print("COST-OF-CARRY RATE IN BLACK MODEL");

  double dTheta = 0.03;
  double dLambda = 0.05;
  double dSigma = 0.2;
  double dInitialTime = 0.75;

  print(dTheta, "theta");
  print(dLambda, "lambda");
  print(dSigma, "sigma");
  print(dInitialTime, "initial time", true);

  Function uCostOfCarry = prb::carryBlack(dTheta, dLambda, dSigma, dInitialTime);
  double dInterval = 1;
  test::Data::print(uCostOfCarry, dInitialTime, dInterval);
}

void yieldSvensson()
{
  test::print("SVENSSON YIELD CURVE");

  double dLambda1 = 0.05;
  double dLambda2 = 0.07;
  double dC0 = 0.02;
  double dC1 = 0.04;
  double dC2 = 0.06;
  double dC3 = 0.03;
  double dInitialTime = 1.5;

  print(dC0, "c0");
  print(dC1, "c1");
  print(dC2, "c2");
  print(dC3, "c3");
  print(dLambda1, "lambda 1");
  print(dLambda2, "lambda 2");
  print(dInitialTime, "initial time", true);

  Function uYield =
    prb::yieldSvensson(dC0, dC1, dC2, dC3, dLambda1,
		       dLambda2, dInitialTime);
  double dInterval = 5;
  test::Data::print(uYield, dInitialTime, dInterval);
}

void forwardCouponBond()
{
  test::print("FORWARD PRICES FOR A COUPON BOND");

  cfl::Data::CashFlow uBond = test::HullWhite::swapParameters();
  uBond.notional = 1.;
  double dRate = uBond.rate;
  double dInitialTime = 1.;
  Function uDiscount = cfl::Data::discount(dRate, dInitialTime);
  test::print(dRate, "interest rate");
  test::print(dInitialTime, "initial time", true);
  test::printCashFlow(uBond, "bond parameters");

  for (int iI = 0; iI < 2; iI++)
    {
      bool bClean = (iI == 0) ? true : false;
      if (bClean)
	{
	  cout << "clean prices:" << endl;
	}
      else
	{
	  cout << "dirty prices:" << endl;
	}
      cout << endl;
      double dRate = uBond.rate;
      double dPeriod = uBond.period;
      double dMaturity = dInitialTime + dPeriod * uBond.numberOfPayments;
      Function uForwardCouponBond =
	prb::forwardCouponBond(dRate, dPeriod, dMaturity, uDiscount,
			       dInitialTime, bClean);
      double dInterval =
	uBond.period * uBond.numberOfPayments / 1.1;
      test::Data::print(uForwardCouponBond, dInitialTime, dInterval);
    }
}

std::function<void()> test_Homework1()
{
  return []() {
	   print("DATA CURVES FOR FINANCIAL MODELS");
	   volatilityVar();
	   carryBlack();
	   yieldSvensson();
	   forwardCouponBond(); 
	 };
}

int main()
{
  project(test_Homework1(), PROJECT_NAME, PROJECT_NAME,
          "Homework 1");
}
