#include "test/Main.hpp"
#include "test/Black.hpp"
#include "test/Print.hpp"
#include "Session3/Output.hpp"
#include "Session3/Session3.hpp"

using namespace test;
using namespace cfl;
using namespace std;
using namespace test::Black;

MultiFunction americanButterfly(AssetModel &rModel)
{
  test::print("AMERICAN BUTTERFLY OPTION IN ASSET MODEL");
  double dPutStrike = test::Black::c_dSpot * 0.9;
  double dCallStrike = test::Black::c_dSpot * 1.1;
  const std::vector<double> uExerciseTimes = test::Black::exerciseTimes();

  print(dPutStrike, "strike for put");
  print(dCallStrike, "strike for call", true);
  test::print(uExerciseTimes.begin(), uExerciseTimes.end(), "exercise times");

  return prb::americanButterfly(dPutStrike, dCallStrike,
                                uExerciseTimes, rModel);
}

MultiFunction callOnForwardPrice(AssetModel &rModel)
{
  test::print("CALL ON FORWARD PRICE IN ASSET MODEL");

  double dStrike = test::Black::c_dSpot;
  double dCallMaturity = test::Black::c_dMaturity;
  double dForwardMaturity = dCallMaturity + 0.5;

  print(dStrike, "strike");
  print(dCallMaturity, "maturity of call");
  print(dForwardMaturity, "maturity of forward", true);

  return prb::callOnForwardPrice(dStrike, dCallMaturity,
                                 dForwardMaturity, rModel);
}

MultiFunction corridor(AssetModel &rModel)
{
  test::print("CORRIDOR OPTION IN ASSET MODEL");

  double dNotional = test::Black::c_dNotional;
  double dLowerBarrier = test::Black::c_dSpot * 0.95;
  double dUpperBarrier = test::Black::c_dSpot * 1.1;
  const std::vector<double>
      uBarrierTimes = test::Black::exerciseTimes();

  print(dNotional, "notional");
  print(dLowerBarrier, "lower barrier");
  print(dUpperBarrier, "upper barrier", true);
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::corridor(dNotional, dLowerBarrier, dUpperBarrier,
                       uBarrierTimes, rModel);
}

MultiFunction downOutCall(AssetModel &rModel)
{
  test::print("DOWN-AND-OUT CALL OPTION IN ASSET MODEL");

  double dStrike = test::Black::c_dSpot;
  double dMaturity = test::Black::c_dMaturity;
  double dLowerBarrier = test::Black::c_dSpot * 0.9;
  const std::vector<double>
      uBarrierTimes = test::Black::barrierTimes();

  print(dStrike, "strike");
  print(dMaturity, "maturity");
  print(dLowerBarrier, "lower barrier", true);
  test::print(uBarrierTimes.begin(), uBarrierTimes.end(), "barrier times");

  return prb::downOutCall(dLowerBarrier, uBarrierTimes,
                          dStrike, dMaturity, rModel);
}

std::function<void()> test_Session3()
{
  return []() {
    print("OPTIONS ON A SINGLE STOCK IN BLACK MODEL");

    AssetModel uModel = test::Black::model();

    report(americanButterfly, uModel);
    report(callOnForwardPrice, uModel);
    report(corridor, uModel);
    report(downOutCall, uModel);
  };
}

int main()
{
  project(test_Session3(), PROJECT_NAME, PROJECT_NAME,
          "Session 3");
}
