% file mynewt.m
% this function finds a root of sin(x)-cos(x)+exp(-x) 
% using Newton's method
function x=mynewt(xguess)

f=@(x) sin(x)-cos(x)+exp(-x);
fprime=@(x) cos(x)+sin(x)-exp(-x);

x=xguess;
tol=1e-10;

while abs(f(x)) > tol
    x=x-f(x)/fprime(x)
end
end
