# Use like
# python euclid.py 21 13
# or
# python euclid.py 15351 12600
import numbers

def euclid(t, b, verbose=True):
    """
    Implementation of Euclid's method for
    computing the greatest common divisor
    of two natural numbers.
    """
    assert t >= b
    assert b > 0
    assert isinstance(t, numbers.Integral)
    assert isinstance(b, numbers.Integral)

    while b > 0:
        (q, r) = (t // b, t % b)

        if verbose:
            print(f"{t} = {q} x {b} + {r}")

        (t, b) = (b, r)
    return t

if __name__ == "__main__":
    import sys

    (t, b) = int(sys.argv[1]), int(sys.argv[2])
    print(f"gcd({t, b}) = {euclid(t, b)}")
