def bisection(f, a, b, tol):
    """
    The bisection algorithm for rootfinding.
    """

    assert f(a)*f(b) < 0

    iterations = 0
    while abs(b - a)/2 > tol:
        iterations += 1
        c = (a + b) / 2
        print(f"Iteration {iterations:3d}: c = {c:.16e} f(c) = {f(c):.16e}")

        if f(c) == 0:
            break
        elif f(c)*f(a) < 0:
            b = c
        else:
            a = c

    return c

if __name__ == "__main__":
    from math import *

    bisection(lambda x: x - cos(x), -10, 10, 1e-9)
