from itertools import count

def unaccelerated():
  out = 0
  for n in count():
    out += (-1)**n / float(2*n+1)
    yield out

def aitken(seq):
  values = (next(seq), next(seq), next(seq))
  while True:
    shat = values[0] - (values[1] - values[0])**2/float(values[2] -2*values[1] + values[0])
    yield shat
    values = (values[1], values[2], next(seq))

from itertools import islice
from math import pi

N = 19
print(f"Unaccelerated sequence: error at {N=}: ", 4.0 * next(islice(unaccelerated(), N, N+1)) - pi)
print(f"Aitken applied once:    error at {N=}: ", 4.0 * next(islice(aitken(unaccelerated()), N, N+1)) - pi)
print(f"Aitken applied twice:   error at {N=}: ", 4.0 * next(islice(aitken(aitken(unaccelerated())), N, N+1)) - pi)
print(f"Aitken applied thrice:  error at {N=}: ", 4.0 * next(islice(aitken(aitken(aitken(unaccelerated()))), N, N+1)) - pi)
