def fixedpoint(g, x0, tol):
    """
    Execute a fixed point iteration
      x_{i+1} = g(x_i)
    """

    iterations = 0
    print(f"Iteration {iterations:2d}: fixed point = {x0:.16e}")

    x = g(x0)
    iterations += 1
    print(f"Iteration {iterations:2d}: fixed point = {x:.16e}")
    while abs(x - x0) > tol:
        x0 = x
        x = g(x0)
        iterations += 1
        print(f"Iteration {iterations:2d}: fixed point = {x:.16e}")

    return x

if __name__ == "__main__":
    from math import *

    # This converges well:
    fixedpoint(lambda x: (x+1)/x, 1.1, 1e-9)

    # This does not converge well:
    #fixedpoint(sin, 0.1, 1e-9)
