# An implementation of Newton's method

def newton(f, g, x0, tol):
    # Initial evaluation
    x = x0
    fx = f(x)
    iterations = 0
    print(f"Iteration {iterations:2d}: x = {x:e} f(x) = {fx:e}")

    while abs(fx) > tol:
        iterations += 1
        x = x - fx/g(x)
        fx = f(x)
        print(f"Iteration {iterations:2d}: x = {x:e} f(x) = {fx:e}")

    return x

if __name__ == "__main__":
    f = lambda x: (x-4)*(x-1)*(x+3)
    g = lambda x: 3*x**2 - 4*x - 11

    # Starting from one initial guess, we converge to -3:
    newton(f, g, 2.352836327, 1e-6)

    # and from a very slightly different initial guess, we converge to 1:
    newton(f, g, 2.352836323, 1e-6)
