# Horner's scheme for polynomial rootfinding:
# combining Newton's method with two runs
# of Horner's evaluation scheme for polynomials,
# to compute the function and its derivative.

def horner(a, x, tol, maxit):
    iterations = 0

    # Newton loop
    while iterations < maxit:
        b = a[-1]                         # compute b_n
        c = b                             # compute c_{n-1}
        b = b*x + a[-2]                   # compute b_{n-1}

        for r in range(len(a)-3, -1, -1): # steps of -1 down to zero
            c = c*x + b                   # compute c_r
            b = b*x + a[r]                # compute b_r

        print(f"Iteration {iterations:2d}: x = {x:.8e} p(x) = {b:.8e} p'(x) = {c:.8e}")

        if abs(b) < tol:
            return x
        else:
            x = x - b/c

        iterations += 1

    raise ValueError("Didn't converge")

if __name__ == "__main__":
    horner([12, -11, -2, 1], 0, 1e-10, 50)
