# Steffensen's method, applying Aitken acceleration to fixed point iterations.

def steffensen(g, x0, tol, exact=None):
    iterations = 0
    x = x0
    s = f"Iterations {iterations:2d}: fixed point = {x:.15e}"
    if exact is not None:
        s = s + f" error = {abs(x-exact):.15e}"
    print(s)
    gx = g(x)
    iterations += 1

    while abs(gx - x) > tol:
        x0 = x
        x1 = gx
        x2 = g(x1)
        iterations += 1

        # We wrote Steffensen's formula like
        # x = (x0*x2 - x1^2)/(x2 - 2*x1 + x0);
        # in the slides. But the following formula
        # has much better numerical properties
        # in floating-point arithmetic.
        x = x0 - (x1-x0)**2 / (x2 - 2*x1 + x0);
        s = f"Iterations {iterations:2d}: fixed point = {x:.15e}"
        if exact is not None:
            s = s + f" error = {abs(x-exact):.15e}"
        print(s)

        gx = g(x);
        iterations = iterations + 1;

    return gx

if __name__ == "__main__":
    from math import *

    # This converges well:
    steffensen(lambda x: (x+1)/x, 1.1, 1e-12, exact=(1+sqrt(5))/2)

    # This does not:
    #steffensen(sin, 0.1, 1e-6)
