function [x,R] = blendenpik(A,b)
% Modified version of the pseudo-code in the original Blendenpik paper, 
% which can also deal with underdetermined systems by performing the 
% decohered QR factorisation on the transpose of A.

  [m,n] = size(A);
  if m >= n
    A1 = A;
  else
    A1 = A';
  end
  
  % take a decohered sample of the rows
  d = sign(randn(m, 1));
  A1 = dct(d .* A1); 
  A1(1, :) = A1(1, :) / sqrt(2);
  r = max(2*n,n*log(m)*log(n*log(m)));
  r = min(r,m);
  %r = min(r,4*n);
  A1 = A1(randsample(m,r),:);
  
  % produce QR factorisation
  [~,R] = qr(A1,0);
  
  % print out some vitals
  % sizeR = size(R)
  % condR = cond(R)
  % condAoverR = cond(A/R)
  
  % solve the system with R as preconditioner
  if m >= n
    x = lsqr(A,b,1e-12,100,R);
  else
    x = lsqr(R'\A,R'\b,1e-12,100);
  end
  
end