%% LSQR
m = 10000; n = 100; 
clf

MS = 'Markersize'; LW = 'linewidth'; FS = 'fontsize'; CO = 'Color'; TEX = 'interpreter'; tex = 'latex';
lw = 2; ms = 12; fs = 14; 
co = {'b','r','k','m',[0 .6 0],[.6 0 0],[0 0 .6]}; linestyles = {'-','--',':','-.'}; markers = {'o','x','^','s'};

noiselevel = 1e-6;

conds = -[1 4];
it = 0;
for con = conds
    it = it+1;
[Q,~] = qr(randn(m,n),0);
[V,~] = qr(randn(n));
A = Q*diag(logspace(con,0,n))*V;
x = randn(n,1);
b = A*x; b = b/norm(b);
e = randn(m,1); e = e-Q*(Q'*e); e = e/norm(e)*noiselevel;
b = b+e;
b = b/norm(b);

%[x,flag,relres,iter,resvec] = pcg(A'*A,A'*b,0,n);
[x,flag,relres,iter,resvecnoP] = lsqr(A,b,1e-12,100);
resvecnoP = resvecnoP/norm(b);
semilogy(resvecnoP,'.-',CO,co{it}),shg
chebfunsetting
%text(length(resvec)*0.6,0.8*resvec(end),['plain CG, $\kappa_2(A)=$',num2str(cond(A))],FS,fs,TEX,tex)
hold on

[x,R] = blendenpik(A,b);
AA = A/R;
%[x,flag,relres,iter,resvec] = lsqr(AA,b,1e-12,100,R);
[x,flag,relres,iter,resvec] = lsqr(A,b,1e-12,100,R);
%[x,flag,relres,iter,resvec] = pcg(AA'*AA,AA'*b,0,n);
resvec = resvec/norm(b);
semilogy(resvec,'.-',CO,co{it}),shg
%text('Blendenpik')
grid on

end
title('CG convergence, $\kappa_2(A)=10,10^4$',TEX,tex,FS,fs)
text(length(resvecnoP)*.5,6*resvecnoP(end),'plain CG $\kappa_2(A)=10^4$',FS,fs,TEX,tex,CO,'r')
text(length(resvecnoP)*0.4,1e-1*resvecnoP(end),'plain CG $\kappa_2(A)=10$',FS,fs,TEX,tex,CO,'b')

text(length(resvec)*.6,resvec(end)*.5,'Blendenpik',FS,fs,CO,'r')
xlim([1 100])

ylim([noiselevel/10 10])


  % try sketch-solve
  A1 = [A b];
  d = sign(randn(m, 1));
  A1 = dct(d .* A1); 
  A1(1, :) = A1(1, :) / sqrt(2);
  r = 2*n;
  A1 = A1(randsample(m,r),:);
  xx = A1(:,1:end-1)\A1(:,end);
  res = norm(A*xx-b)/norm(b);
  X = xlim;
  semilogy(X,[1 1]*res,'m--',LW,lw/2),shg
  text(length(resvec)*1.2,res*2,'sketch+solve',FS,fs,CO,'m')

  xlabel('CG iterations',FS,fs)
  ylabel('$||Ax-b||$',TEX,tex,FS,fs)

% export_figmy(['Blendenpik_sketchsolve_conv'])


xxx = A\b; 
  res = norm(A*xxx-b)/norm(b);
  X = xlim;
  semilogy(X,[1 1]*res,'b:',LW,lw/2),shg
  text(length(resvec)*2.5,res*.6,'QR',FS,fs)

  %{

  con = -4;
[Q,~] = qr(randn(m,n),0);
[V,~] = qr(randn(n));
A = Q*diag(logspace(con,0,n))*V;
x = randn(n,1);
b = A*x; b = b/norm(b);
e = randn(m,1); e = e-Q*(Q'*e); e = e-Q*(Q'*e); e = e/norm(e)*noiselevel;
b = b+e;
b = b/norm(b);

xx = A\b; 
norm(A*xx-b)
  %}