%% Murphy-Golub-Wathen preconditioner
n = 20;
A = randn(n); B = randn(n); C = randn(n); 
O = zeros(n); 
AA = [A B;C O]; % saddle point matrix 
M = blkdiag(A,C*inv(A)*B); % preconditioner
eig(inv(M)*AA)
%%
N = 2*n; x = randn(N,1); b = AA*x;
clf, 
MS = 'Markersize'; LW = 'linewidth'; FS = 'fontsize'; CO = 'Color'; TEX = 'interpreter'; tex = 'latex';
lw = 2; ms = 12; fs = 14; 

[x,flag,relres,iter,resvec] = gmres(AA,b,N,1e-10,N); % GMRES
semilogy(resvec,'.-',MS,ms),hold on, grid on 
text(length(resvec)/2,resvec(round(end/2))/5,'unpreconditioned')
[x,flag,relres,iter,resvec] = gmres(AA,b,N,1e-10,N,M); % preconditioned GMRES
semilogy(resvec,'.--',MS,ms),shg
text(length(resvec)*.9,resvec(end),'preconditioned',CO,'r')
xlabel('GMRES iterations',FS,fs)
ylabel('$||Ax^{(k)}-b||$',FS,fs,TEX,tex)