n = 500;

% for eigvals in disk
A0 = randn(n)/sqrt(n); shift = 2; A = A0+shift*eye(n); [X,V] = eig(A); % shift = 2+3i;

% eigvals on real interval
%X = eye(n); A = X*diag(linspace(1,3,n))/X; shift = 2;

clf

ei = eig(A); 
chebfunsetting
plot(ei+1i*eps,'.k',MS,ms)
shg
grid on, hold on
circle([real(shift) imag(shift)],1);
title('eig(A)',FS,fs)
grid on
plot(0,0,'r.',MS,ms*2)
ax = axis;
axis([-0.5 ax(2:4)]), axis equal
hold off

%export_figmy(['eigArandshift',num2str(shift)])
%line([0 ax(2)],[0 0]),line([0 0],[ax(3) ax(4)])
%% GMRES
b = randn(n,1); 
[x,flag,relres,iter,resvec] = gmres(A,b,n,1e-10,n);
clf,
semilogy(resvec,'.-'),shg, grid on
hold on 
itt = 1:iter(end);
if abs(shift)>.1, semilogy(itt,resvec(1)*(1/abs(shift)).^(itt-1),'--'),shg, grid on,end
h_legend = legend('$||Ax^{(k)}-b||$','$1/2^k$ via $\frac{(z-2)^k}{2^k}$',TEX,tex);
%h_legend = legend('$||Ax^{(k)}-b||$','theory',TEX,tex);
if norm(imag(eig(A)))==0, sk=sqrt(cond(A)); semilogy(itt,2*resvec(1)*((sk-1)/(sk+1)).^(itt-1),'b--'),shg, grid on
h_legend = legend('$||Ax^{(k)}-b||$','$1/2^k$ via $\frac{(z-2)^k}{2^k}$','Cheb bound $(\frac{\sqrt{\kappa(A)}-1}{\sqrt{\kappa(A)}+1})^k$',TEX,tex);   end

set(h_legend,'FontSize',14,'Location','Best');
xlabel('GMRES iterations',FS,fs)
% export_figmy(['GMRESconv'])

%% Arnoldi for eigenvalues
%A = linspace(-1,1,n)';
A = exp(2*pi*1i*[1:n]/n); 
A(end) = 2;
A(end-1) = 3i;

X = randn(n);
A = X*diag(A)*inv(X);

k = 20;
[Q,H] = arnoldi(A,randn(n,1),k);

clf
plot(eig(A)+1i*eps,'k.',MS,ms),hold on
plot(eig(H(1:k,1:k)),'ro',MS,ms/2)
grid on, shg, axis equal

%%

n = 500;
A = randn(n)/sqrt(n);
clf
shift = 5; 
A = A+shift*eye(n);
ei = eig(A); 
chebfunsetting
plot(ei,'.k',MS,ms)
shg
ax = axis;
axis([-0.5 ax(2:4)]), axis equal
grid on, hold on
circle([shift 0],1)
title('eig(A)',FS,fs)
plot(0,0,'r.',MS,ms*2)
hold off
b = randn(n,1); 
[x,flag,relres,iter,resvec] = gmres(A,b,n,1e-10,n);
semilogy(resvec,'.-'),hold on,shg
x0 = x;



%%
[Q,H] = arnoldi(A,b,length(resvec));
subspace(Q,x)
%
%
ei = eig(A); 
A = A-ei(1)*eye(n);
%[x,flag,relres,iter,resvec] = gmres(A,A*x0,n,1e-10,n);
[x,flag,relres,iter,resvec] = gmres(A,A*x0,n,1e-10,n,[],[],b);
semilogy(resvec,'.-'),shg, hold on
[x,flag,relres,iter,resvec] = gmres(A,A*randn(n,1),n,1e-10,n);
semilogy(resvec,'.-'),shg, hold on

%%
%A = A-ei(1)*eye(n);
[Q,H] = arnoldi(A,b,20);
subspace(Q,x)

xx = (A*Q)\(A*x0); norm(A*Q*xx-A*x0)
%x1 = randn(n,1); xx = (A*Q)\(A*x1); norm(A*Q*xx-A*x1)