n = 1000; % size
A = gallery('randsvd',n,1e100); % geometrically decaying singvals
sv = svd(A);
r = 200; % rank

%% HMT error
X = randn(n,r); % HMT
AX = A*X;
[Q,R] = qr(AX,0); % QR fact.
At = Q*(Q'*A);
norm(At-A,'fro')/norm(A,'fro')

%% HMT error as r grows
err = [];
rvals = 10:10:r;
for rnow = rvals
X = randn(n,rnow); % HMT
AX = A*X;
[Q,R] = qr(AX,0); % QR fact.
At = Q*(Q'*A);
%err = [err norm(At-A,'fro')/norm(A,'fro')];    
err = [err norm(At-A)];    
end
%%
clf,
semilogy(rvals,sv(rvals+1),'k--'),hold on
semilogy(rvals,err,'r.--','markersize',13), grid on

MS = 'Markersize'; LW = 'linewidth'; FS = 'fontsize'; CO = 'Color'; TEX = 'interpreter'; tex = 'latex';
lw = 2; ms = 12; fs = 14; 
xlabel('rank',FS,fs)
ylabel('$||A-\hat A_r||_2$','interpreter','latex',FS,fs)
shg
h_legend=legend('$\sigma_i(A)$','HMT',FS,fs,'interpreter','latex');
set(h_legend,'FontSize',17,'Location','Best');


%% Generalised Nystrom
X = randn(n,r); Y = randn(n,1.5*r);
AX = A*X; YA = Y'*A; YAX = YA*X;
[Q,R] = qr(YAX,0); % stable p-inv
At = (AX/R)*(Q'*YA);
norm(At-A,'fro')/norm(A,'fro')

%%
errGN = [];
rvals = 10:10:r;
for rnow = rvals
X = randn(n,rnow); Y = randn(n,1.5*rnow);
AX = A*X; YA = Y'*A; YAX = YA*X;
[Q,R] = qr(YAX,0); % stable p-inv
At = (AX/R)*(Q'*YA);
%err = [err norm(At-A,'fro')/norm(A,'fro')];    
errGN = [errGN norm(At-A)];    
end
%%
semilogy(rvals,errGN,'bo-','markersize',5), grid on
hold off, shg
h_legend=legend('$\sigma_i(A)$','HMT','GN',FS,fs,'interpreter','latex');
set(h_legend,'FontSize',17,'Location','Best');
shg
