import matplotlib.pyplot as plt

seabornblue  = (0.2980392156862745, 0.4470588235294118, 0.6901960784313725)
seabornred   = (0.7686274509803922, 0.3058823529411765, 0.3215686274509804)
seaborngreen = (0.3333333333333333, 0.6588235294117647, 0.40784313725490196)

a = [2**(-n) for n in range(101)]
b = [(n+1)**(-1) for n in range(101)]
c = [(2**(-2**n)) for n in range(11)]

(fig, subaxs) = plt.subplots(1, 3, figsize=(20,10))
plt.subplots_adjust(wspace=0.2, hspace=0.2)
subaxs[0].semilogy(range(len(a)), a, "-", color=seabornblue,  label="(a)")
subaxs[1].semilogy(range(len(b)), b, "-", color=seabornred,   label="(b)")
subaxs[2].semilogy(range(len(c)), c, "-", color=seaborngreen, label="(c)")
for ax in subaxs:
    ax.set_xlabel(r"$n$")
    ax.legend()
subaxs[0].set_ylabel(r"$e_n$")
plt.show()
