import mpmath
mpmath.mp.dps = 100

from mpmath import log, pi, mpf, fabs
from itertools import count

def leibniz():
  # Use a Python generator to model the infinite
  # sequence of partial sums
  out = 0
  for n in count():
    out += (-1)**n / mpf(2*n+1)
    yield 4*out

from itertools import islice

N = 10003

# Take the first 10003 terms in the
# sequence of partial sums
base = list(fabs(x - pi) for x in islice(leibniz(), 0, N))
def convergence_stats(errors):
    q = log(errors[-1]/errors[-2]) / \
        log(errors[-2]/errors[-3])
    M = errors[-1]/errors[-2]**q
    return (q, M)

(q, M) = convergence_stats(base)
print(f"Convergence statistics: e_(n+1) = {float(M):.4e} * e_n^({float(q):.4e})")
