from sheet1_q2_extended_euclid import extended_euclid
import math

p = 137
q = 173

n = p*q
lambda_n = (p-1)*(q-1)//math.gcd(p-1, q-1)

e = 7

(d, _) = extended_euclid(e, lambda_n, 1)
d = d % lambda_n

print(f"Private key: d = {d}")
assert d*e % lambda_n == 1

m = 21051
c = pow(m, e, n)
o = pow(c, d, n)

print(f"Message:     m = {m}")
print(f"Ciphertext:  c = {c}")
print(f"Decrypted:   o = {o}")
assert o == m
