# An implementation of Newton's method

def newton(f, g, x0, tol):
    # Initial evaluation
    x = x0
    fx = f(x)
    iterations = 0
    print(f"Iteration {iterations:2d}: x = {x:e} f(x) = {fx:e}")

    while abs(fx) > tol:
        iterations += 1
        x = x - fx/g(x)
        fx = f(x)
        print(f"Iteration {iterations:2d}: x = {x:e} f(x) = {fx:e}")

    return x

if __name__ == "__main__":
    from math import *

    print("Part (a)")
    print("-"*80)
    f = lambda x: sin(x) * sinh(x)
    g = lambda x: cos(x) * sinh(x) + sin(x) * cosh(x)
    newton(f, g, 0.5, 1e-8)

    print()
    print("Part (b)")
    print("-"*80)
    f = lambda x: x - sin(x)
    g = lambda x: 1 - cos(x)
    newton(f, g, 0.5, 1e-8)

    print()
    print("Part (c)")
    print("-"*80)
    f = lambda x: x * cos(x)
    g = lambda x: cos(x) - x * sin(x)
    newton(f, g, 0.5, 1e-8)

