import numpy as np
from sheet2_q4_newton import newton

a = 1
b = 100

def E(X):
    (x, y) = X
    return (a - x)**2 + b*(y-x**2)**2

def F(X):
    (x, y) = X
    return np.array([-2*a - 4*b*x*(-x**2 + y) + 2*x, b*(-2*x**2 + 2*y)])

def J(X):
    (x, y) = X
    return np.array([[8*b*x**2 - 4*b*(-x**2 + y) + 2, -4*b*x],
                     [-4*b*x, 2*b]])

def I(X):
    return 2000*np.eye(2)

print("Newton's method: ")
print(newton(F, J, [100, 100], 1.0e-8))
print("-"*80)
print("Gradient descent: ")
print(newton(F, I, [2, 2], 1.0e-8))
