import numpy as np

def newton(F, J, x, tol):
    x = np.array(x, dtype=np.float64)
    norm = np.linalg.norm(F(x))
    iter = 0

    print(f"Iteration {iter:02d}: ||F(x)|| = {norm:.2e}")

    while norm > tol:
        delta = np.linalg.solve(J(x), -F(x))
        x += delta
        norm = np.linalg.norm(F(x))
        iter += 1
        print(f"Iteration {iter:02d}: ||F(x)|| = {norm:.2e}")

    return x

if __name__ == "__main__":

    def F(X):
        (x, y) = X
        return np.array([x**2 - y - 1, x - y**2 + 1])

    def J(X):
        (x, y) = X
        return np.array([[2*x, -1],
                         [1, -2*y]])

    print(newton(F, J, [-1.2, 0], 1.0e-8))  # converges to [-1, 0]
    print(newton(F, J, [0, -1.2], 1.0e-8))  # converges to [0, -1]
    print(newton(F, J, [-0.6, -0.6], 1.0e-8))  # converges to [-1/phi, -1/phi]
    print(newton(F, J, [1.6, 1.6], 1.0e-8))  # converges to [phi, phi]
