% plot cheb polys 
subplot(3,1,1)
plot(chebpoly(0),LW,lw), text(0.5,0.5,'$T_0(x)$',TEX,tex,FS,fs), grid on, ylim([-1 1.1])
subplot(3,1,2)
plot(chebpoly(1),LW,lw), text(0.5,0.1,'$T_1(x)$',TEX,tex,FS,fs), grid on 
subplot(3,1,3)
plot(chebpoly(2),LW,lw), text(0.5,0.5,'$T_2(x)$',TEX,tex,FS,fs), grid on 
shg
%%
subplot(3,1,1)
plot(chebpoly(3),LW,lw), text(0.5,0.5,'$T_3(x)$',TEX,tex,FS,fs), grid on
subplot(3,1,2)
plot(chebpoly(4),LW,lw), text(0.5,0.5,'$T_4(x)$',TEX,tex,FS,fs), grid on
subplot(3,1,3)
plot(chebpoly(5),LW,lw), text(0.5,0.5,'$T_5(x)$',TEX,tex,FS,fs), grid on
shg
% export_figmy(['chebpoly_123'])
%%
subplot(3,1,1)
plot(chebpoly(3),[-2 1],LW,lw), text(0.5,0.5,'$T_3(x)$',TEX,tex,FS,fs), grid on
subplot(3,1,2)
plot(chebpoly(4),[-2 1],LW,lw), text(0.5,0.5,'$T_4(x)$',TEX,tex,FS,fs), grid on
subplot(3,1,3)
plot(chebpoly(5),[-2 1],LW,lw), text(0.5,0.5,'$T_5(x)$',TEX,tex,FS,fs), grid on
shg
% export_figmy(['chebpoly_345'])
 export_figmy(['chebpoly_345_outside'])
%%
k = [0 2 4 10 20 40 60];
x = chebfun('x'); one = 1 + 0*x;
FS = 'fontsize'; fs = 14;
for j = 1:length(k)
  plot3(j*one,x,chebpoly(k(j)),'linewidth',1.6), hold on
end
axis([1 length(k) -1 1 -1 1])
box on
set(gca,'dataaspectratio',[1 0.75 4]), view(-72,28)
set(gca,'xticklabel',k)
xlabel('k',FS,fs), ylabel('x',FS,fs), set(gca,FS,fs)
h = get(gca,'xlabel'); set(h,'position',get(h,'position')+[1.5 0.1 0])
h = get(gca,'ylabel'); set(h,'position',get(h,'position')+[0 0.25 0])